%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Universidade do Estado de Santa Catarina             
%                
%---------------------------------------------------------------------------
% Definicao do arquivo de classe UDESC - Modelo de Dissertação/Tese UDESC
%---------------------------------------------------------------------------
% Versão 1.0.0
% Histórico:
% 1 - Criação do arquivo base;
%                                                           
% (c)2013 Eduardo Henrique Couto (ehcouto@hotmail.com)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                         
% This file may be distributed and/or modified              
%
% 1. under the LaTeX Project Public License and/or          
% 2. under the GNU Public License.                          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

%\NeedsTeXFormat{LaTeX2e}   % Identifica a versão de LaTeX em uso
\ProvidesClass{./Data/udesc}       % Informa o tipo de documentclasse que ele é

%---------------------------------------------------------------------------
% Passa as opções não interessantes para a classe base ABNTex
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{./Data/abnt}}
%\DeclareOption*{\PassOptionsToClass{\CurrentOption}{./Data/abntex2}}

\ProcessOptions

%---------------------------------------------------------------------------
% Carrega classe ABNTex, com padrão de página A5, fonte 11pt, frente e verso

%%%Use essa opção para A5, frente e verso
%\LoadClass[a5paper,10pt,twoside,capchap,capsec,openright,espacosimples,normaltoc]{./Data/abnt}
%\RequirePackage[a5paper,inner=2.5cm,outer=1.5cm,top=2.0cm,bottom=1.5cm,head=0.7cm,foot=0.7cm]{geometry}


%%%Use essa opção para A5, apenas frente
%\LoadClass[a5paper,10pt,oneside,capchap,capsec,openright,espacosimples,normaltoc]{./Data/abnt}
%\RequirePackage[a5paper,inner=2.5cm,outer=1.5cm,top=2.0cm,bottom=1.5cm,head=0.7cm,foot=0.7cm]{geometry}



%%%Use essa opção para A4, apenas frente
\LoadClass[a4paper,12pt,twoside,capchap,capsec,openright,espacoumemeio,normaltoc,times]{./Data/abnt}
\RequirePackage[a4paper,inner=3cm,outer=2cm,top=3.0cm,bottom=2cm]{geometry}


%---------------------------------------------------------------------------
% Definicao da geometria da página
% Se o cabecalho e o rodape estao dentro das margens, acrescentar as opcoes includehead e includefoot

%---------------------------------------------------------------------------
% Definicao de espacamento simples
\RequirePackage{setspace}

%---------------------------------------------------------------------------
% Pacote de definicoes da tese padrao UDESC
\RequirePackage{./Data/udescsty}


%---------------------------------------------------------------------------
% Definicoes de fontes usadas no documento
%\RequirePackage{amsmath, amssymb, amsfonts, amsthm}
%\RequirePackage{fix-cm}
%\renewcommand{\normalsize}{\fontsize{10.5pt}{12.5pt}\selectfont}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Substituicao e criacao de comandos relacionados ao ABNTex
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%---------------------------------------------------------------------------
% Executa o comando #2 se o argumento #1 não estiver vazio, senão executa #3
\newcommand{\UDESCifnotempty}[3]{\ifthenelse{\not\equal{#1}{}}{#2}{#3}}

%---------------------------------------------------------------------------
% Formatação de capitulos
\renewcommand{\ABNTchaptersize}{\normalsize} % Fonte de capítulo

\ifthenelse{\boolean{ABNTcapchap}}
  {\renewcommand{\ABNTchapterfont}{\bfseries}}
  {\renewcommand{\ABNTchapterfont}{\bfseries}}
\renewcommand{\ABNTtocchapterfont}{\ABNTchapterfont}
%\renewcommand{\ABNTtocchapterfont}{\bfseries}

\providecommand{\nometoc}{}

% \@chapter : 
\def\@chapter[#1]#2%
      {\ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\theHchapter}{\chaptertype\thechapter}}{}
       \ifnum \c@secnumdepth >\m@ne
         \refstepcounter{chapter}%
         \ABNTchaptermark{#1}% This command MUST came before addcontentsline
         \typeout{\@chapapp\space\thechapter.}%
         % gambiarra usada para definir maiusculas para capitulos comuns e normal para anexos e apêndices
         \ifthenelse{\boolean{ABNTcapchap}}
               {\renewcommand{\nometoc}{\MakeUppercase{#1}}}
               {\renewcommand{\nometoc}{#1}}
         \ifthenelse{\boolean{ABNTaftertoc}}
           {\ABNTaddcontentsline{toc}{chapter}%
                   {\protect\numberline{\thechapter}\nometoc}}
           {}
       \else
         \ABNTchaptermark{#1}% This command MUST came before addcontentsline
         \ifthenelse{\boolean{ABNTaftertoc}}%
           {\ABNTaddcontentsline{toc}{chapter}{\nometoc}}%
           {}%
       \fi       
       \if@twocolumn
         \@topnewpage[\@makechapterhead{#2}]%
       \else
         \@makechapterhead{#2}%
         \@afterheading
       \fi\par}
       
       
       
%--------------------------------------------------------------------------       
%% Figuras e tabelas com o capítulo
%%figuras
       \renewcommand \thefigure
            {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@figure}
       \def\fps@figure{tbp}
       \def\ftype@figure{1}
       \def\ext@figure{lof}
       \def\fnum@figure{\figurename\nobreakspace\thefigure}
% tabelas      
  	   \renewcommand \thetable
  	            {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@table}
%---------------------------------------------------------------------------       
% Formato de cabecalho de capitulo
\def\@makechapterhead#1{%
\  {%
  \noindent\rule{\textwidth}{0pt}\par
  %\normalfont\ABNTchaptersize\ABNTchapterfont%
%  \LARGE      % Definir o tamanho da fonte do título do capítulo
  \bfseries 
  \espaco{simples}%
  \vspace*{-12pt}%
  \noindent%
  \parbox[b]{\textwidth}{%
    \parbox[t]{1em}{\thechapter}%
    \parbox[t]{\textwidth-4ex-1ex}%
      {\interlinepenalty\@M
        \raggedright%
        \ifthenelse{\boolean{ABNTcapchap}}%
          {\MakeUppercase{#1}}%
          {#1}
      }%
    \vspace*{0cm}
    }\\[2pt]%
  \vspace{0pt}%
  }%
}

% Defining how is typeset the \chapter*
\def\@makeschapterhead#1{%
  \vspace*{0pt}\par
  {\centering\normalfont\ABNTchaptersize\ABNTchapterfont%
   \ifthenelse{\boolean{ABNTcapchap}}%
     {\MakeUppercase{#1}}%
     {#1}
    \par}%
  \vspace{21pt}%
  \par%
}




%---------------------------------------------------------------------------
% Formatação de seções
% Font which section titles will be printed
%\renewcommand{\ABNTsectionfont}{}
%\large     % Definir o tamanho da fonte do título da seção
\bfseries  
\def\ABNTstartsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\ABNTssect{#1}{#4}{#5}{#6}}% #3 replaced by #1 here
    {\@dblarg{\ABNTsect{#1}{#2}{#3}{#4}{#5}{#6}}}}

\renewcommand{\@seccntformat}[1]{%
  \csname the#1\endcsname\hspace{0.25ex}
}

\def\ABNTsect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax \@svsec}%
          \interlinepenalty \@M 
          \ifthenelse{\boolean{ABNTcapsec}\and\equal{#2}{1}}
             {\MakeUppercase{#8}}{#8}\@@par}%
    \endgroup
    \@ifundefined{ABNT#1mark}{}{\csname ABNT#1mark\endcsname{#7}}
    \ABNTaddcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec \ifthenelse{\boolean{ABNTcapsec}}
             {\MakeUppercase{#8}}{#8}}%
      \@ifundefined{ABNT#1mark}{}{\csname ABNT#1mark\endcsname{#7}}
      \ABNTaddcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}

%---------------------------------------------------------------------------
% Número de níveis de subseções
\setcounter{tocdepth}{5} %profundidade no sumário
\setcounter{secnumdepth}{5} %profundidade no trabalho

%---------------------------------------------------------------------------
% Formatação das seções e seus componentes
\renewcommand\section{\ABNTstartsection{section}{1}{\z@}%
                           {-4ex}%
                           {4ex}%
                           {\espaco{simples} %\normalfont%
                           % \ABNTsectionfont
                           \MakeUppercase\normalsize}}
                            
\renewcommand\subsection{\ABNTstartsection{subsection}{2}{\z@}%
                           {-4ex}%
                           {4ex}%
                           {\espaco{simples}\normalfont%
                           \ABNTsectionfont\normalsize\bfseries}}
                           %\large     % Definir o tamanho da fonte do título da seção
                           %\bfseries 
\renewcommand\subsubsection{\ABNTstartsection{subsubsection}{3}{\z@}%
                           {-4ex}%
                           {4ex}%
                           {\espaco{simples}\normalfont%
                         %   \ABNTsectionfont\normalsize}}
                                   \normalsize}}
                            %\large     % Definir o tamanho da fonte do título da seção
                            %\bfseries 
\renewcommand\paragraph{\ABNTstartsection{paragraph}{4}{\z@}%
                           {-4ex}%
                           {4ex}%
                           {\espaco{simples}\normalfont%
                            \ABNTsectionfont\normalsize\itshape}}
                            %\large     % Definir o tamanho da fonte do título da seção
                            %\bfseries 
\newcommand{\itab}[1]{\hspace{0em}\rlap{#1}}
\newcommand{\tab}[1]{\hspace{.2\textwidth}\rlap{#1}}
%---------------------------------------------------------------------------
% Lista de figuras, tabelas, símbolos, siglas
\newcommand{\filltocentry}[1]{%
 {\hspace{0em}\normalfont\dotfill}\nobreak
 \hb@xt@\@pnumwidth{\hfil\normalfont #1}{}\par}

\renewcommand*{\l@figure}[2]{
      \vskip -1em
      \leftskip -1.5em
      \rightskip 1.6em
      \parfillskip -\rightskip
      \parindent 0em
      \@tempdima 2em % Distância entre a numeração da figura e o label
      \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
      {\figurename~\normalfont #1}\nobreak \filltocentry{#2}}

\renewcommand*{\l@table}[2]{
       \vskip -1em
       \leftskip -1.5em
       \rightskip 1.6em
       \parfillskip -\rightskip
       \parindent 0em
       \@tempdima 2em % Distância entre a numeração da tabela e o label
       \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
       {\tablename~\normalfont #1}\nobreak \filltocentry{#2}}

\newcommand{\listadesimbolos}{
    \pretextualchapter{Lista de S\'{i}mbolos}\@starttoc{lsb}}
    %Arthur -> tipos de inserção de simbolo
\newcommand{\simbolo}[2]{\addcontentsline{lsb}{simb}{\numberline{#1}{#2}}}
\newcommand{\simap}[2]{\addcontentsline{lsb}{simb}{\numberline{#1}{#2}}#1}
\newcommand{\simbolouni}[3]{\addcontentsline{lsb}{simb}{\numberline{#1}{\itab{#2}\tab{\tab{\tab{#3}}}}}}
\newcommand{\simapuni}[3]{\addcontentsline{lsb}{simb}{\numberline{#1}{\itab{#2}\tab{\tab{\tab{#3}}}}}#1}


\newcommand{\l@simb}[2]{
       \vskip -1em
       \leftskip -4.5em
       %\rightskip 1.2em
       %\parfillskip -\rightskip
       \parindent 0em
       \@tempdima 5em
       \advance\leftskip \@tempdima \null\nobreak \hskip -\leftskip
       {\normalfont #1}\nobreak}% \filltocentry{#2}}


\newcommand{\listadeabreviaturas}{
    \pretextualchapter{Lista de Abreviaturas e Siglas}\@starttoc{las}}
\newcommand{\abreviatura}[2]{\addcontentsline{las}{sig}{\numberline{#1}{#2}}}
\newcommand{\sigla}{\abreviatura}
\newcommand{\l@sig}[2]{
       \vskip -1em
       \leftskip -4.5em
      %\rightskip 1.2em
       %\parfillskip -\rightskip
       \parindent 0em
      \@tempdima 7.5em
       \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
       {\normalfont #1}\nobreak}% \filltocentry{#2}} tinha esse comando e coloquei a chave ali que não tinha

\newcommand{\listadeabreviaturasestrangeiras}{
    \pretextualchapter{Lista de Abreviaturas e Siglas Estrangeiras}\@starttoc{lse}}
\newcommand{\abreviaturaestrangeira}[2]{\addcontentsline{lse}{sig}{\numberline{#1}{\ingles{#2}}}}
\newcommand{\siglaestrangeira}{\abreviaturaestrangeira}
\newcommand{\sigest}{\abreviaturaestrangeira}
\newcommand{\l@sigestrangeira}[2]{
       \vskip -1em
       \leftskip -4.5em
      %\rightskip 1.2em
       %\parfillskip -\rightskip
       \parindent 0em
      \@tempdima 7.5em
       \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
       {\normalfont#1}\nobreak}% \filltocentry{#2}} tinha esse comando e coloquei a chave ali que não tinha

%---------------------------------------------------------------------------
% Apêndices e Anexos - Pós-Textuais
\renewcommand{\annexname}{ANEXO}
\renewcommand{\appendixname}{AP\^{E}NDICE} % for completeness ;-)
\renewcommand{\ABNTanapsize}{\normalsize}

\renewcommand{\apendice}{\appendix}
\renewcommand{\anexo}{\annex}

\def\@anapchapter[#1]#2%
      {
       \refstepcounter{chapter}%
       \ifthenelse{\boolean{ABNTAnApName}}
        {
         \begingroup
         \ifthenelse{\equal{#1}{}}
            {\def\thechapter{\anapchaptername{} \Alph{chapter}}}
            {\def\thechapter{\anapchaptername{} \Alph{chapter}{}
                                \ABNTtravessao{} #1}} 
         \ABNTchaptermark{}
         \endgroup
         \if@twocolumn
           \@topnewpage[\@makeanapchapterhead{#2}]%
         \else
           \@makeanapchapterhead{#2}%
           \@afterheading
         \fi
        }
        {
         \ABNTchaptermark{#1}
         \if@twocolumn
            \@topnewpage[\@makechapterhead{#2}]%
         \else
            \@makechapterhead{#2}%
            \@afterheading
         \fi
        }
       \ifnum \c@secnumdepth >\m@ne
         \typeout{\@chapapp\space\thechapter.}%
         \ifthenelse{\boolean{ABNTAnApName}}{
           \ifthenelse{\equal{#1}{}}
              {\ABNTaddcontentsline{toc}{chapter}%
                  {\MakeUppercase{\anapchaptername{}} \thechapter}}
              {\ABNTaddcontentsline{toc}{chapter}%
                  {\MakeUppercase{\anapchaptername{}} \thechapter{} \ABNTtravessao{} #1}}
         }
         {
          \ABNTaddcontentsline{toc}{chapter}%
                   {\protect\numberline{\thechapter}#1}
         }  
       \else
         \ABNTaddcontentsline{toc}{chapter}{#1}
       \fi
       \par
      }


\def\@makeanapchapterhead#1{%
  \thispagestyle{empty} 	% Define o estilo desta página como vazio   
  \normalfont
  \ABNTchapterfont
  \espaco{simples}
  \begin{center}
   \MakeUppercase{\anapchaptername}
   \thechapter{} \ABNTtravessao{} \ABNTaposindicativoanap {#1}
  \end{center}
  \normalfont
}

\def\ABNTstartsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\ABNTssect{#1}{#4}{#5}{#6}}% #3 replaced by #1 here
    {\@dblarg{\ABNTsect{#1}{#2}{#3}{#4}{#5}{#6}}}}

\renewcommand{\@seccntformat}[1]{%
  \csname the#1\endcsname\hspace{0.25ex}
}

\def\anapsect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax \@svsec}%
          \interlinepenalty \@M 
          \ifthenelse{\boolean{ABNTcapsec}\and\equal{#2}{1}}
             {\MakeUppercase{#8}}{#8}\@@par}%
    \endgroup
    \@ifundefined{ABNT#1mark}{}{\csname ABNT#1mark\endcsname{#7}}
%     \ABNTaddcontentsline{toc}{#1}{%
%       \ifnum #2>\c@secnumdepth \else
%         \protect\numberline{\csname the#1\endcsname}%
%       \fi
%       #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec \ifthenelse{\boolean{ABNTcapsec}}
             {\MakeUppercase{#8}}{#8}}%
      \@ifundefined{ABNT#1mark}{}{\csname ABNT#1mark\endcsname{#7}}
%       \ABNTaddcontentsline{toc}{#1}{%
%         \ifnum #2>\c@secnumdepth \else
%           \protect\numberline{\csname the#1\endcsname}%
%         \fi
%         #7}
	}%
  \fi
  \@xsect{#5}}

\renewcommand{\appendix}{
  \setcounter{chapter}{0}
  \resetsubcounters{chapter}
  \gdef\thechapter{\Alph{chapter}}
  \ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\chaptertype}{appen.}}{}
  \gdef\@chapapp{Apendice}
  \renewcommand{\anapchaptername}{\appendixname}
  \global\let\@chapter\@anapchapter
  \global\let\ABNTsect\anapsect}

\let\apendice\appendix

\renewcommand{\annex}{
  \setcounter{chapter}{0}
  \resetsubcounters{chapter}
  \gdef\thechapter{\Alph{chapter}}
  \ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\chaptertype}{annex.}}{}
  \gdef\@chapapp{Anexo}
  \renewcommand{\anapchaptername}{\annexname}
  \global\let\@chapter\@anapchapter
  \global\let\ABNTsect\anapsect}

\let\anexo\annex


%---------------------------------------------------------------------------
% Formatação do parágrafo
\setlength{\parindent}{1cm} % Define indentação de 1cm para o parágrafo
\setlength{\parskip}{0cm}   % Sem espaço entre parágrafos

%---------------------------------------------------------------------------
% Redefinição do estilo ruledheader

\renewcommand{\ps@ruledheader}{%
  \renewcommand{\@oddfoot}{}%
  \renewcommand{\@evenfoot}{}%
  \renewcommand{\@oddhead}%
     {\underline{\makebox[\textwidth]{\raisebox{-.5ex}{}%
       {\rightmarkformat\rightmark}\hfill{\thepageformat\thepage}}}}%
  \renewcommand{\@evenhead}%
     {\underline{\makebox[\textwidth]{\raisebox{-.5ex}{}%
       {\thepageformat\thepage}\hfill{\leftmarkformat\leftmark}}}}%
% Para \chapter* mostrar o cabecalho
  \let\@mkboth\ABNTmarkboth%
% Definindo a maneira como o comando o \chapter marca o cabecalho
  \renewcommand{\chaptermark}[1]{%
    \markboth%
	{##1}{##1}
%        {\ifnum \c@secnumdepth >\m@ne%
%             \thechapter\ \ %
%         \fi%
%         ##1}%
%        {\ifnum \c@secnumdepth >\m@ne%
%             \thechapter\ \ %
%         \fi%
%         ##1}%
  }%
  \renewcommand{\sectionmark}[1]{%
    \markright
	{##1}
%       {%
%       \ifnum \c@secnumdepth >\z@%
%         \thesection\ \ %
%       \fi%
%       ##1}%
  }%   
}% 

%---------------------------------------------------------------------------
% Estilo do texto da folha de rosto
\newenvironment{textodafolhaderosto}%
  {\begin{espacosimples}%
   \small
   \begin{list}{}{%
       \setlength{\listparindent}{0cm}%
       \setlength{\itemindent}{\listparindent}%
       \setlength{\rightmargin}{0cm}%
       \setlength{\leftmargin}{0.5\linewidth}%
       \setlength{\parsep}{0pt}}%
    \item\relax}%
  {\end{list}\end{espacosimples}}

%---------------------------------------------------------------------------
% Estilo da dedicatoria e da epigrafe
\newenvironment{textorecuadopretextual}%
  {\begin{espacosimples}%
   \small
   \begin{list}{}{%
       \setlength{\listparindent}{0cm}%
       \setlength{\itemindent}{\listparindent}%
       \setlength{\rightmargin}{0cm}%
       \setlength{\leftmargin}{0.5\linewidth}%
       \setlength{\parsep}{0pt}}%
    \item\relax}%
  {\end{list}
   \end{espacosimples}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Substituicao e criacao de elementos de documento do ABNTex
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\let\ps@empty\ps@plain

%-------------------------------------------------------------------------------
% Redefinicao da capa do ABNTex
\renewcommand{\capa}
{
\if@openright		% Garante que se a página for "direita"
    \cleardoublepage	% ele pula uma página para deixar o anverso em branco
\else
    \clearpage
\fi
\if@twocolumn		% Força que a página seja de uma coluna apenas
    \@restonecoltrue\onecolumn
\else
    \@restonecolfalse\newpage
\fi
\thispagestyle{empty} 	% Define o estilo desta página como vazio
%\setcounter{page}\z@	% Reseta o contador de páginas. Parece não ser necessário aqui
\begin{center}
    \begin{onehalfspacing}
	\small{\textbf{UNIVERSIDADE DO ESTADO DE SANTA CATARINA \\
	CENTRO DE CI\^{E}NCIAS TECNOL\'{O}GICAS \\
	DEPARTAMENTO DE ENGENHARIA EL\'{E}TRICA\\
	P\'{O}S-GRADUA\c{C}\~{A}O EM ENGENHARIA EL\'{E}TRICA}}
    \end{onehalfspacing}
\end{center}
\vfill
\begin{center}
    {\textbf{
    \ABNTifnotempty{\ABNTautordata}%
	{%
	%\MakeUppercase{\autorformat\ABNTautordata}
               \textbf{\MakeUppercase{\ABNTautordata}}
	}
	}
	}
\end{center}
\vfill
\begin{center}
    \begin{onehalfspacing}
	{
	\ABNTifnotempty{\ABNTtitulodata}%
	    {%
	    \UDESCifnotempty{\subtitulodata}%
		{%
		\tituloformat{\ABNTtitulodata}:~\par
		\tituloformat{\subtitulodata}\par
		}%
		{%
		\tituloformat{\ABNTtitulodata}\par
		}%
	    }}
	\end{onehalfspacing}
\end{center}
\vspace{0.3\textheight}
\begin{center}
    \begin{onehalfspacing}
    \setlength{\parskip}{.3cm}
    \ABNTifnotempty \ABNTlocaldata
	\textbf{\MakeUppercase{\ABNTlocaldata}} \par
    \ABNTifnotempty{\anodata}
	\textbf{\anodata}
	\end{onehalfspacing}
\end{center}
\vspace{1cm}
\if@restonecol\twocolumn \else \newpage \fi
\setcounter{page}\z@	% Reseta o contador de páginas. Parece não ser necessário aqui
}% end of \capa

%-------------------------------------------------------------------------------
% Redefinicao da folha de rosto do ABNTex
\renewcommand{\folhaderosto}[1][semficha]%
{%
\if@openright		% Garante que se a página for "direita"
    \cleardoublepage	% ele pula uma página para deixar o anverso em branco
\else
    \clearpage
\fi
\if@twocolumn		% Força que a página seja de uma coluna apenas
    \@restonecoltrue\onecolumn
\else
    \@restonecolfalse\newpage
\fi
\thispagestyle{empty} 	% Define o estilo desta página como vazio

\begin{center}
    \begin{onehalfspacing}
		   \ABNTifnotempty{\ABNTautordata}%
			{%
	%\textbf{\MakeUppercase{\autorformat\ABNTautordata}}
                \textbf{\MakeUppercase{\ABNTautordata}}  %coloque mais autores aqui se desejar
			}
    \end{onehalfspacing}
\end{center}
\vspace{1.2cm}

\vspace{4.7cm}
\begin{center}
    \begin{onehalfspacing}
    \ABNTifnotempty{\ABNTtitulodata}%
	{%
	\UDESCifnotempty{\subtitulodata}%
	    {%
	    \tituloformat{\ABNTtitulodata}:\ \tituloformat{\subtitulodata}\par
	    }%
	    {%
	    \tituloformat{\ABNTtitulodata}\par
	    }%
	}%
    \end{onehalfspacing}
\end{center}
\vspace{1cm}
\begin{textodafolhaderosto}
	\begin{onehalfspace}
	{\comentarioformat\UDESCcomentariodata}\par
    \ABNTifnotempty{\ABNTorientadordata}%
	{%
	\vspace{0.25cm}\comentarioformat
		\textbf{{\ABNTorientadordata}}:\ {\ABNTorientadorname}\protect\\
	}
    \ABNTifnotempty{\ABNTcoorientadordata}
	{%  
		\comentarioformat
		\textbf{{\ABNTcoorientadordata}}:\ {\ABNTcoorientadorname} %nome do orientador e coorientador na folha rosto (em negrito, os títulos)
	}
	\end{onehalfspace}
\end{textodafolhaderosto}
\vfill
\begin{center}
    \begin{onehalfspacing}
    \setlength{\parskip}{.3cm}
    \ABNTifnotempty \ABNTlocaldata
	\textbf{\MakeUppercase{\ABNTlocaldata}} \par %coloca local na folha rosto
    \ABNTifnotempty{\anodata}
		\textbf{\anodata} %coloca a data na folha rosto
	\end{onehalfspacing}
\end{center}
\vspace{1cm}
\ifthenelse{\equal{#1}{comficha}}
    {\newpage
     \mbox{}
     \vfill
     \conteudofichacatalografica
    }{}
}% end of \folhaderosto

%-------------------------------------------------------------------------------
% Definicao da folha de aprovacao
%\newcommand{\folhaaprovacao}%
%{%
%\if@openright\cleardoublepage\else\clearpage\fi%
%\if@twocolumn
%    \@restonecoltrue\onecolumn
%\else
%    \@restonecolfalse\newpage
%\fi
%\thispagestyle{empty}%
%%\setcounter{page}\z@
%\vfill
%\begin{center}
%    \begin{onehalfspacing}
%    \ABNTifnotempty{\ABNTtitulodata}%
%	{%
%	"\UDESCifnotempty{\subtitulodata}%
%	    {%
%	    \tituloformat{\ABNTtitulodata}:~\tituloformat{\subtitulodata}\par
%	    }%
%	    {%
%	    \tituloformat{\ABNTtitulodata}"\par
%	    }%
%	}%
%    \end{onehalfspacing}
%\end{center}
%
%\begin{center}
%por
%\end{center}
%	
%	\ABNTifnotempty{\ABNTautordata}%
%    {%
%    \begin{center}
%    \textbf{\ABNTautordata}
%    \end{center}
%    }
%\begin{onehalfspacing}
%\centering
%\textoAprovacaodata\par
%\end{onehalfspacing}
%
%\begin{minipage}[h!]{0.35\textwidth}
%
%\flushleft
%Banca Examinadora:\linebreak
%\newline
%\small \ABNTlocaldata, \diadata\ de \mesdata\ \anodata.\par
%\end{minipage} 
%\hfill
%\begin{minipage}[h!]{0.62\textwidth}
%\vspace{1.5cm}
%	% Banca A
%    \begin{center}
%	{\rule{6cm}{1pt}\par
%	\bancanameadata \\ \bancadataadata}
%	\end{center}
%    \vfill
%        
%	% Banca B
%    \begin{center}
%	{\rule{6cm}{1pt}\par
%	\bancanamebdata \\ \bancadatabdata}
%	\end{center}
%    \vfill
%       
%    %Banca C
%    \begin{center}
%    {\rule{6cm}{1pt}\par
%    \bancanamecdata \\ \bancadatacdata}
%    \end{center}
%	\vfill
%	
%	% Banca D
%	\begin{center}
%	{\rule{6cm}{1pt}\par
%	\bancanameddata \\ \bancadataddata}
%	\end{center}
%   	   	
%\end{minipage} 
%}% end of \aprovacao

\newcommand{\folhaaprovacao}%
{%

\if@openright\cleardoublepage\else\clearpage\fi%
\if@twocolumn
    \@restonecoltrue\onecolumn
\else
    \@restonecolfalse\newpage
\fi
\thispagestyle{empty}%
%\setcounter{page}\z@
\vfill

\ABNTifnotempty{\ABNTautordata}%
{%
\begin{center}
\textbf{\MakeUppercase\ABNTautordata}
\end{center}
}
\vspace{1cm}
\begin{center}
    \begin{onehalfspacing}
    \ABNTifnotempty{\ABNTtitulodata}%
	{%
	\UDESCifnotempty{\subtitulodata}%
	    {%
	    \tituloformat{\ABNTtitulodata}:~\tituloformat{\subtitulodata}\par
	    }%
	    {%
	    \tituloformat{\ABNTtitulodata}\par
	    }%
	}%
    \end{onehalfspacing}
\end{center}

	

\begin{onehalfspacing}
\noindent Dissertação apresentada ao curso de Mestrado Profissional do Programa de Pós-graduação em Engenharia Elétrica como requisito parcial para obtenção do título de Mestre em Engenharia Elétrica na área de concentração de "Controle e Acionamentos".
\par
\end{onehalfspacing}
\vspace{1cm}
\begin{onehalfspacing}
\noindent\textbf{Banca Examinadora}
\end{onehalfspacing}
\vspace{1cm}
\begin{flushleft}
\begin{tabular}{lcc}
Orientador: & &  \\\cline{3-3}
& & \bancanameadata \\
& & \bancadataadata \\
& & \\
Coorientadora: & & \\\cline{3-3}
& & \bancanameddata \\
& & \bancadataddata \\
& & \\
Membros: & & \\\cline{3-3}
& & \bancanamebdata \\
& & \bancadatabdata \\
& & \\
& &  \\\cline{3-3}
& & \bancanamecdata \\
& & \bancadatacdata \\
& & \\
\end{tabular}
\end{flushleft}
\vspace{1cm}

\hfill
%\begin{minipage}[h!]{0.62\textwidth}
%\vspace{1.5cm}
%	% Banca A
%    \begin{center}
%	{\rule{6cm}{1pt}\par
%	\bancanameadata \\ \bancadataadata}
%	\end{center}
%    \vfill
%        
%	% Banca B
%    \begin{center}
%	{\rule{6cm}{1pt}\par
%	\bancanamebdata \\ \bancadatabdata}
%	\end{center}
%    \vfill
%       
%    %Banca C
%    \begin{center}
%    {\rule{6cm}{1pt}\par
%    \bancanamecdata \\ \bancadatacdata}
%    \end{center}
%	\vfill
%	
%	% Banca D
%	\begin{center}
%	{\rule{6cm}{1pt}\par
%	\bancanameddata \\ \bancadataddata}
%	\end{center}
% 	   	
%\end{minipage}
\\
\begin{center}
\small \ABNTlocaldata, \diadata\ de \mesdata\ \anodata.
\end{center}
  
}% end of \aprovacao


%-------------------------------------------------------------------------------
% Definicao da página de dedicatória
\newcommand{\paginadedicatoria}%
{%
\if@openright		% Garante que se a página for "direita"
    \cleardoublepage	% ele pula uma página para deixar o anverso em branco
\else
    \clearpage
\fi
\if@twocolumn		% Força que a página seja de uma coluna apenas
    \@restonecoltrue\onecolumn
\else
    \@restonecolfalse\newpage
\fi
\thispagestyle{empty} 	% Define o estilo desta página como vazio
\mbox{}
\vfill
\ABNTifnotempty{\dedicatoriadata}%
    {%
    \begin{textorecuadopretextual}
	{\dedicatoriaformat\dedicatoriadata}\par
    \end{textorecuadopretextual}
    }
\vfill
\mbox{}
}% end of \dedicatoria

%-------------------------------------------------------------------------------
% Definicao da página de de agradecimentos
\newcommand{\paginaagradecimento}%
{%
\if@openright		% Garante que se a página for "direita"
    \cleardoublepage	% ele pula uma página para deixar o anverso em branco
\else
    \clearpage
\fi
\if@twocolumn		% Força que a página seja de uma coluna apenas
    \@restonecoltrue\onecolumn
\else
    \@restonecolfalse\newpage
\fi
\thispagestyle{empty} 	% Define o estilo desta página como vazio
\ABNTifnotempty{\agradecimentodata}%
    {%
    \begin{center}
	\tituloformat{\agradecimentoname}
    \end{center}
    \vspace{2.5cm}
    \begin{espacosimples}
	\agradecimentoformat\agradecimentodata
    \end{espacosimples}
    }
}% end of \agradecimento

%-------------------------------------------------------------------------------
% Definicao da página da epígrafe
\newcommand{\paginaepigrafe}%
{%
\if@openright		% Garante que se a página for "direita"
    \cleardoublepage	% ele pula uma página para deixar o anverso em branco
\else
    \clearpage
\fi
\if@twocolumn		% Força que a página seja de uma coluna apenas
    \@restonecoltrue\onecolumn
\else
    \@restonecolfalse\newpage
\fi
\thispagestyle{empty} 	% Define o estilo desta página como vazio
\mbox{}
\vfill\vfill
\ABNTifnotempty{\epigrafedata}%
    {%
    \begin{textorecuadopretextual}
	{\epigrafeformat\epigrafedata}\par
    \end{textorecuadopretextual}
    \ABNTifnotempty{\epigrafeautordata}%
	{%
	\begin{textorecuadopretextual}
	    {\epigrafeautorformat\epigrafeautordata}\par
	\end{textorecuadopretextual}
	}
    }
\vfill\vfill
\mbox{}
}% end of \epigrafe

%-------------------------------------------------------------------------------
% Redefinicao do ambiente resumo ,palavras-chave e keywords ABNTex
\renewcommand{\resumoname}{Resumo}
\renewenvironment{resumo}%
  {%
   \if@openright\cleardoublepage\else\clearpage\fi%
   \ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\chaptertype}{resumo.}}{}
   \pretextualchapter{\resumoname}%
   \ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\chaptertype}{}}{}
   \begin{espacosimples}\setlength{\parindent}{0cm}%
  }%
  {\end{espacosimples}
   \ABNTifnotempty{\palavrasChavedata}
	{\par\setlength{\parindent}{0cm}{\bfseries Palavras-chave:} \palavrasChavedata}
   \newpage}%resumo

%-------------------------------------------------------------------------------
% Definicao da página do resumo
\newcommand{\paginaresumo}
{
\ABNTifnotempty{\textoResumodata}
    {
    \begin{resumo}
    \textoResumodata\\
    \end{resumo}
     }
}

%-------------------------------------------------------------------------------
% Redefinicao dos ambientes abstract,resumo,palavras-chave e keywords ABNTex
\renewcommand{\ABNTabstractname}{Abstract}
\renewenvironment{abstract}%
  {%
   \if@openright\cleardoublepage\else\clearpage\fi%
   \ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\chaptertype}{abstract.}}{}
   \pretextualchapter{\ABNTabstractname}%
   \ifthenelse{\boolean{ABNThypertoc}}{\renewcommand{\chaptertype}{}}{}
   \begin{espacosimples}\setlength{\parindent}{0cm}%
  }%
  {\end{espacosimples}
   \ABNTifnotempty{\keywordsdata}
	{\par\setlength{\parindent}{0cm}{\bfseries Keywords:} \keywordsdata}
   \newpage}%abstract

%-------------------------------------------------------------------------------
% Definicao da página do abstract
\newcommand{\paginaabstract}
{
\ABNTifnotempty{\textAbstractdata}
     {
     \begin{abstract}
     \textAbstractdata\\
     \end{abstract}
     }
}

\endinput
