### h20 regression

library(MASS)
data("Boston")


#load h20
library(h2o)
h2o.init()
h2o.no_progress()  # Turn off progress bars for notebook readability

#Transforming data in a h2o object.

df<-as.h2o(Boston)

#Let's take a look at the data.

h2o.describe(df)


#save the column name as `y`. 
#In this dataset, we will use all columns except the response as predictors, so we can skip setting the `x` argument explicitly.

y <- "medv"

# split the data into two frames, a `train` (80%) and a `test` frame (20%). 

splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

## Run AutoML

aml <- h2o.automl(y = y,
                  training_frame = train,
                  leaderboard_frame = test,
                  max_runtime_secs = 60,
                  seed = 123)

## Leaderboard

#Next, we will view the AutoML Leaderboard.

print(aml@leaderboard)

## Predict Using Leader Model

pred <- h2o.predict(aml, test)  
head(pred)


#performance
perf <- h2o.performance(aml@leader, test)
perf

#R2
r2 <- h2o.r2(aml@leader)
r2


#Model interpretation

h2o.permutation_importance_plot(aml@leader,test)
h2o.partialPlot(aml@leader,test)
h2o.residual_analysis_plot(aml@leader,test)


h2o.shutdown()

