figure(1), clf

% Vetor posio da bola
po = [50 50];

% definimos o formato do
% objeto como bola quando inserimos o cdigo'ko', onde k se refere a cor
% preta e o se refere a geometria.
ploth = plot(po(1),po(2),'ko','markersize',30,'markerface','g')

set(gca,'xlim',[0 100],'ylim',[0 100],'xtick',[],'ytick',[])%os []  para
% desativar as escalas quando visualiza o grfico. [0 100]  o novo tamanho
% e escala do grfico, definimos assim para facilitar durante a escrita do
% cdigo.
title('Quadro animado .')%ttulo apenas, nada de mais.

% plot boundary - hora de delimitar as fronteiras, no caso sero linhas 
% pontilhadas formando um quadrado. Ns vamos escolher um tamanho limite
% para esse quadrado, que seria de 80 unidades.
hold on
plot([10 90],[10 10],'k:')%plot com as devidas coordenadas.'k:' significa
% k cor preta e : so linhas pontilhadas
plot([10 90],[90 90],'k:')
plot([10 10],[10 90],'k:')
plot([90 90],[10 90],'k:')

while 1
    
    timenow = rem(now,1)*50000;%funo que retorna a hora atual em segundos
%     retorna o restante aps diviso de a por b, ou seja hora atual por 1.
    po(1)  = po(1) + sin(timenow) + randn;%coordenada x da bola, loc(1)  o local anterior
    po(2)  = po(2) + cos(timenow) + randn;%coordenada y da bola
    
    % O que a bola vai fazer quando bater na "parede"
    po(po<0) = 1;
    po(po>100) = 99;
        
    % Trocar a bola de cor
    if any(po<10) || any(po>90)%qualquer posio inferior a 10 unidades entra no if, onde
%         a bola verde fica vermelha
       set(ploth,'MarkerFaceColor','r');
    else%caso contrrio any>=10 a bola fica verde. Lembrando que  o centro da bola que conta.
       set(ploth,'MarkerFaceColor','g');
    end
    
    set(ploth,'XData',po(1),'YData',po(2))%a ideia aqui  atualizar as coordenadas
    pause(.05)
end


%%
