%% Exemplo simples
[x,y] = meshgrid(0:0.2:2,0:0.2:2);
u = cos(x).*y;
v = sin(x).*y;

figure
quiver(x,y,u,v)
%%
syms y(t)
% Estamos especificando explicitamente que y  uma funo de t
eq = diff(y) == exp(-t) - 2*y;% Aqui estamos dizendo que a derivada de y  igual a exp -2y
 

% Encontrar a soluo geral
dsolve(eq)
% exp(-t) + C4*exp(-2*t) esta  a soluo proposta pelo matlab onde C4 
% uma constante

% Encontrar uma soluo particular a partir das condies de contorno
dsolve(eq,y(0)==2)

%% 
[tt,yy] = meshgrid(linspace(-2,3,30),linspace(-1,2,32));
% Estamos usando essa funo meshgrid para gerar valores dentro na faixa de
% -2 a 30 determinado pelo linspace. Fazemos assim, pois estamos
% trabalhando com duas variveis.
sol = exp(-tt) - 2*yy;
% Lembrando aqui que estamos lidando com matrizes.

% Normalizar vetores para a plotagem
figure(2), clf, hold on
L = sqrt(1+sol.^2);%Estamos usando um fator de normalizao, podemos fazer isso para olhar 
% melhor a direo das setas. se colocarmos apenas sol, que  a soluo,
% teramos ainda uma 'curva' de setas, mas no  bem vista.
h = quiver(tt,yy,1./L,sol./L,.5);
% o ltimo valor se refere a escala da seta (.5) u e v so as componentes
% dos vetores que so exibidos nas coordenadas tt e yy.
 
set(h,'linew',2,'color',[.8 .8 .8])

% estamos aqui especificando vetores com valores iniciais pata t e y
initvals = [ 2 1 .75 .5 ];

h1 = zeros(size(initvals));
for i=1:length(initvals)
    h1(i) = ezplot(dsolve(eq,y(0)==initvals(i)),[min(tt(:)) max(tt(:))]);%eu quero resolver a EDO para uma soluo especfica
end

% Ajustar os eixos
axis ([min(tt(:)) max(tt(:)) min(yy(:)) max(yy(:))])%estou definindo para os eixos maximos e mnimos
% que me permitem ter melhor visualizao
set(h1,'linew',1)

%% Referncias
%COHEN, Mike X; BUCHALKA, Tim.Master MATLAB through Guided Problem Solving. 
%Disponvel em: https://www.udemy.com/course/master-matlab-through-guided-problem-solving/. 
%Acesso em: 02 mar. 2020.
