%% Usando ezplot
% no  recomendado, o mathworks recomenda usar no lugar a funo fplot
% ezplot(fun)plota a expresso fun(x)sobre o domnio padro -2? x<<2?, onde fun(x) apenas uma funo explcita x.
% fun pode ser um identificador de funo, um vetor de caractere ou uma string.

figure(1), clf

fx = '10*sin(x) + tan(x/2)/10';
h = ezplot(fx);
set(h,'linew',2)

%% Introduzindo funes annimas

% Funes annimas tem esta forma:

fun = @(x)        x.^2;

whos fun

fun(0)% Aqui s estamos testando a funo, para ver se sai o resultado certo
fun(-3)
%% Usando fplot
% Temos que plotar a partir de uma funo annima

fy = @(y) 10*sin(y) + tan(y/2)/10;
figure(2)

% Se quiser pode pedir para plotar em determinada regio, como por exemplo
h = fplot(fy, [-15 5]);
set(h,'linew',2)

%% Plotando funes implicitas
figure(3)
% Definir a funo como anonima
fts = @(r,t,s) 2.^(t.*s) + r.*s - t.*s.^(1/3);

h = fimplicit3(fts)
rotate3d on, axis image
set(h,'linestyle','none')

%% Plotar funo polar
figure(4)
% Funo annima do cardioid
cardioid = @(t) 2*(1-cos(t));
h = ezpolar(cardioid);
set(h,'linew',2,'color','r')
rotate3d on
%% Referncias
%COHEN, Mike X; BUCHALKA, Tim.Master MATLAB through Guided Problem Solving. 
%Disponvel em: https://www.udemy.com/course/master-matlab-through-guided-problem-solving/. 
%Acesso em: 02 mar. 2020.
