% Derivada simblica de seno de x
syms t
w  = cos(t);
dw = diff(w);

% Plotar a funo e derivadas
figure(1), clf
subplot(211)
fplot(w), hold on
fplot(dw)
% Fazer legenda
legend({[ 'f(t)= ' char(w) ],[ 'df(t)= ' char(dw) ]})
% funo para criar legenda no grfico, aqui estamos transformando essas
% funes e caracteres, ou seja, strings para que possam serem impressas no
% grfico.

%% 
syms x
% Declarar a funo

w = ( exp(x^2)+5*x^3) / (1+cos(x)^2);

% Fazer a derivada
dw = diff(w);

pretty(dw)
% Permite com que a funo fique mais legvel para nossos olhos. O
% mathworks no recomenda essa funo, diz que  prefervel usar live
% scripts.  como se estivesse vendo no livro, s que pior.

% Plotar tudo a
figure(2), clf
fplot(w,'linew',2), hold on
fplot(dw,'linew',2)
legend({'f(x)';'df'})
set(gca,'ylim',[-300 300])

%% Referncias
%COHEN, Mike X; BUCHALKA, Tim.Master MATLAB through Guided Problem Solving. 
%Disponvel em: https://www.udemy.com/course/master-matlab-through-guided-problem-solving/. 
%Acesso em: 02 mar. 2020.

