# mapeia-g.ps1 -- Faz o mapeamento da unidade de rede (G).
#
# Jeverson Passing
# j.passing@udesc.br

Clear-Host

Write-Host -ForegroundColor DarkGray "---------------------------------"
Write-Host -ForegroundColor DarkGray "-- Script para mapeamento do G --"
Write-Host -ForegroundColor DarkGray "---------------------------------`n"

$global:ip = "10.15.2.103"
$global:verificado = $false

function fim {

	if(Test-Path "$env:temp\mapeia-g.tmp") {
		Remove-Item "$env:temp\mapeia-g.tmp"
	}

	Write-Host -ForegroundColor DarkGray "[*] Pressione qualquer tecla para sair...`n"
	cmd /c pause | out-null
	exit

}

function verifica_vpn {

	if((Get-NetAdapter -InterfaceDescription forti* | Out-String -Stream | Select-String -Pattern "Up   ") -eq $null) {

		Write-Host -ForegroundColor Red "[!] Voc precisa estar conectado  VPN antes de prosseguir.`n"
		fim

	}

}

function renomeia_unidade($unidade, $nome){
	(New-Object -ComObject Shell.Application).NameSpace($unidade).Self.Name = $nome
}

function solicita_credenciais {

	Write-Host "[*] Digite suas credenciais do ID UDESC.`n"

	$global:aduser = Read-Host " [+] Usurio"
	$global:pass_enc = Read-Host " [+]   Senha" -AsSecureString
	$global:adpass = [Runtime.InteropServices.Marshal]::PtrToStringAuto([Runtime.InteropServices.Marshal]::SecureStringToBSTR($pass_enc))

}

function testa_conexao {

		net use G: \\$ip\esag $adpass /user:corp\$aduser /persistent:yes 2> "$env:temp\mapeia-g.tmp"

		if (Get-ChildItem "$env:temp\mapeia-g.tmp" | Select-String "xito") {

			$verificado = $true
			return $true

		} else {
			return $false
		}

}

verifica_vpn
net use | findstr G: | Out-File "$env:temp\mapeia-g.tmp"

if (Get-ChildItem "$env:temp\mapeia-g.tmp" | Select-String "G:") {
	net use G: /delete | Out-Null
}

while(!($verificado)) {

	solicita_credenciais

	if(!(testa_conexao)) {
		Write-Host -ForegroundColor Red "`n[!] Credenciais incorretas.`n"
	} else {
		$verificado = $true
	}

}

renomeia_unidade -unidade "G:" -nome "ESAG"

Write-Host -ForegroundColor Green "`n[!] A unidade G foi mapeada.`n"
fim